<%@ include file="/_core/system/directives.jsp" %>

<%@ page import="application.util.AppSettings "%>
<%@ page import="application.orm.persister.WordpressModelFinder" %>

<c:set scope="page" var="wpUser" value="<%= AppSettings.getWordpressAdminUsername() %>" />
<c:set scope="page" var="wpPassword" value="<%= AppSettings.getWordpressAdminPassword() %>" />
<c:set scope="page" var="wpEmail" value="<%= AppSettings.getWordpressAdminEmail() %>" />



<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<c:choose>
	<c:when test="${not empty wpUser && not empty wpPassword && not empty wpEmail}">
		<jsp:include page="/_core/system/include/input.html.jsp">
			<jsp:param name="input_classBox" value="x2" />
			<jsp:param name="input_id" value="titolo" />
			<jsp:param name="input_caption" value="${f:message(LOCALE, 'Titolo')}" />
		</jsp:include>
		
		<br />
		
		<c:set scope="page" var="options">
			<c:forEach items="<%= WordpressModelFinder.getInstance().getAll() %>" var="model">
				${model.id}|${model.nome}||
			</c:forEach>
		</c:set>
		<jsp:include page="/_core/system/include/select.html.jsp">
			<jsp:param name="select_classBox" value="x2" />
			<jsp:param name="select_id" value="idModel" />
			<jsp:param name="select_firstEmpty" value="true" />
			<jsp:param name="select_caption" value="${f:message(LOCALE, 'Modello_wordpress')}" />
			<jsp:param name="select_options" value="${options}" />
		</jsp:include>
		
		<br /><br />
		
		<jsp:include page="/_core/system/include/switch.html.jsp">
			<jsp:param name="switch_id" value="multisite" />
			<jsp:param name="switch_caption" value="Multisite" />
		</jsp:include>
	</c:when>
	
	<c:otherwise>
		${f:formatForHTML(f:message(LOCALE, 'wordpress_install_dati_mancanti'))}
	</c:otherwise>
</c:choose>
