<%@ include file="/_core/system/directives.jsp" %>

<%@ page import="application.util.AppSettings" %>



<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<c:set scope="page" var="VHADD" value="false" />
<c:if test="${ACCOUNT.administrator || ACCOUNT.hasAutorizzazione('VHADD')}">
	<c:set scope="page" var="VHADD" value="true" />
</c:if>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>
<%-- header --%>
<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<jsp:include page="/app/_common/step/search/toolbar.html.jsp">
	<jsp:param name="toolbar_title" value="${f:message(LOCALE, 'Domini')}" />
	<jsp:param name="toolbar_buttonNew" value="${VHADD}" />
</jsp:include>

<div class="mdc-theme--surface mdc-theme--on-surface app-search-advanced-container mdc-elevation--z4">
	<h2 class="title">
		<jsp:include page="/_core/system/include/icon.html.jsp">
			<jsp:param name="icon_icon" value="tune" />
		</jsp:include>
		<span><html:message key="Ricerca_avanzata" /></span>
	</h2>
	
	<jsp:include page="/_core/system/include/input.html.jsp">
		<jsp:param name="input_mapping" value="pojo.idDominio" />
		<jsp:param name="input_customType" value="lookup|url=dominio" />
		<jsp:param name="input_caption" value="${f:message(LOCALE, 'Dominio')}" />
	</jsp:include>
</div>

<input type="hidden" class="requirePageCSS" />

<input type="hidden" class="requirePageJS" />

<input type="hidden" class="max-vhs" value="<%= AppSettings.getSrvMaxVhs() %>" />



<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>
<%-- contenuto della ricerca --%>
<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<div class="app-search-container"></div>

<div class="app-search-next-results" title="${f:message(LOCALE, 'Altri_risultati')}">
	<jsp:include page="/_core/system/include/icon.html.jsp">
		<jsp:param name="icon_icon" value="keyboard_arrow_down" />
	</jsp:include>
</div>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>
<%-- messaggio in caso di ricerca a vuoto --%>
<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<jsp:include page="/app/_common/emptyMessage.html.jsp">
	<jsp:param name="emptyMessage_class" value="app-search-empty-message" />
	<jsp:param name="emptyMessage_text" value="nessun_dominio_trovato" />
</jsp:include>