<%@ include file="/_core/system/directives.jsp"%>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<html:input type="hidden" mapping="pojo.id" />

<div class="gpro-display-flex-row-center">
	<c:choose>
		<c:when test="${ACCOUNT.administrator || ACCOUNT.hasAutorizzazione('FREE-STAGE')}">
			<jsp:include page="/_core/system/include/input.html.jsp">
				<jsp:param name="input_classBox" value="x1_2 gpro-flex-grow" />
				<jsp:param name="input_mapping" value="dominioStaging" />
				<jsp:param name="input_setValue" value="true" />
				<jsp:param name="input_value" value="${BEAN.dominioStaging}.${BEAN.pojo.dominio.nome}" />
			</jsp:include>
			
			<html:input type="hidden" mapping="stagingManuale" value="1" />
		</c:when>
		<c:otherwise>
			<jsp:include page="/_core/system/include/input.html.jsp">
				<jsp:param name="input_classBox" value="x1_2 gpro-flex-grow" />
				<jsp:param name="input_mapping" value="dominioStaging" />
			</jsp:include>
			<span class="gpro-vertical-align-middle gpro-font-size-big">.${BEAN.pojo.dominio.nome}</span>

			<html:input type="hidden" mapping="stagingManuale" value="0" />
		</c:otherwise>
	</c:choose>
</div>

<c:if test="${not empty BEAN.pojos}">
	<div class="gpro-display-flex-row-center">
		<c:set scope="page" var="options">
			<c:forEach items="${BEAN.pojos}" var="item">
				${item.id}|${item.dominio.nome}||
			</c:forEach>
		</c:set>
		<jsp:include page="/_core/system/include/select.html.jsp">
			<jsp:param name="select_classBox" value="gpro-flex-grow" />
			<jsp:param name="select_mapping" value="idVirtualhostStaging" />
			<jsp:param name="select_firstEmpty" value="true" />
			<jsp:param name="select_caption" value="${f:message(LOCALE, 'Staging_attivo')}" />
			<jsp:param name="select_options" value="${options}" />
		</jsp:include>
	</div>
</c:if>