<%@ include file="/_core/system/directives.jsp" %>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>
<%-- toolbar --%>
<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<jsp:include page="/app/_common/step/item/toolbar.html.jsp" />

<section class="mdc-top-app-bar__section mdc-top-app-bar__section--align-end app-window__toolbar--extra">
	<jsp:include page="/_core/system/include/button.html.jsp">
		<jsp:param name="button_class" value="swap swap-to-components" />
		<jsp:param name="button_icon" value="playlist_add_check" />
		<jsp:param name="button_tooltip" value="${f:message(LOCALE, 'Seleziona_componenti')}" />
	</jsp:include>

	<jsp:include page="/_core/system/include/button.html.jsp">
		<jsp:param name="button_class" value="swap swap-to-item ui-helper-hidden" />
		<jsp:param name="button_icon" value="arrow_back" />
		<jsp:param name="button_tooltip" value="${f:message(LOCALE, 'Indietro')}" />
	</jsp:include>
</section>

<input type="hidden" class="requirePageCSS" />

<input type="hidden" class="requirePageJS" />



<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>
<%-- item --%>
<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<div class="panel item">
	<jsp:include page="/_core/system/include/input.html.jsp">
		<jsp:param name="input_classBox" value="x2" />
		<jsp:param name="input_class" value="app-item-title-source" />
		<jsp:param name="input_mapping" value="pojo.nome" />
		<jsp:param name="input_caption" value="${f:message(LOCALE, 'Nome')}" />
	</jsp:include>
	
	<jsp:include page="/_core/system/include/textarea.html.jsp">
		<jsp:param name="textarea_classBox" value="gpro-flex-grow" />
		<jsp:param name="textarea_mapping" value="pojo.descrizione" />
		<jsp:param name="textarea_caption" value="${f:message(LOCALE, 'Descrizione')}" />
	</jsp:include>
	
	<jsp:include page="/_core/system/include/textarea.html.jsp">
		<jsp:param name="textarea_classBox" value="gpro-flex-grow" />
		<jsp:param name="textarea_mapping" value="pojo.note" />
		<jsp:param name="textarea_caption" value="${f:message(LOCALE, 'Note')}" />
	</jsp:include>
</div>



<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>
<%-- components --%>
<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<div class="panel components hidden">
	<c:if test="${not empty BEAN.allLocales}">
		<h3>
			<jsp:include page="/_core/system/include/icon.html.jsp">
				<jsp:param name="icon_icon" value="language" />
			</jsp:include>
			<html:separator />
			<html:message key="Lingue" />
		</h3>
		<c:forEach items="${BEAN.allLocales}" var="item">
			<p>
				<jsp:include page="/_core/system/include/switch.html.jsp">
					<jsp:param name="switch_mapping" value="locales" />
					<jsp:param name="switch_value" value="${item.locale}" />
					<jsp:param name="switch_caption" value="${item.locale}" />
				</jsp:include>
			</p>
		</c:forEach>
	</c:if>

	<c:if test="${not empty BEAN.allThemes}">
		<h3>
			<jsp:include page="/_core/system/include/icon.html.jsp">
				<jsp:param name="icon_icon" value="design_services" />
			</jsp:include>
			<html:separator />
			<html:message key="Temi" />
		</h3>
		<c:forEach items="${BEAN.allThemes}" var="item">
			<p>
				<jsp:include page="/_core/system/include/switch.html.jsp">
					<jsp:param name="switch_mapping" value="themes" />
					<jsp:param name="switch_value" value="${item.theme}|${item.file}" />
					<jsp:param name="switch_caption" value="${item.theme}" />
				</jsp:include>
			</p>
		</c:forEach>
	</c:if>

	<c:if test="${not empty BEAN.allPlugins}">
		<h3>
			<jsp:include page="/_core/system/include/icon.html.jsp">
				<jsp:param name="icon_icon" value="extension" />
			</jsp:include>
			<html:separator />
			Plugins
		</h3>
		<c:forEach items="${BEAN.allPlugins}" var="item">
			<p>
				<jsp:include page="/_core/system/include/switch.html.jsp">
					<jsp:param name="switch_mapping" value="plugins" />
					<jsp:param name="switch_value" value="${item.plugin}|${item.file}" />
					<jsp:param name="switch_caption" value="${item.plugin}" />
				</jsp:include>
			</p>
		</c:forEach>
	</c:if>
</div>