<%@ include file="/_core/system/directives.jsp" %>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>
<%--
	NOTE - il chiamante deve impostare in request (o in scope raggiungibile) l'oggetto da disegnare con nome "POJO"
--%>
<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<div
	class="mdc-card gpro-on-hover-container"
	data-id="${POJO.id}"
	data-key="${f:formatForHTML(POJO.infoLabel)}">
	
	<div class="top">
		<div class="title">
			<h3 class="underline-effect click-effect" action="edit">${f:formatForHTML(POJO.nome)}</h3>
		</div>
		
		<div class="buttons gpro-visible-on-hover">
			<jsp:include page="/_core/system/include/button.html.jsp">
				<jsp:param name="button_icon" value="edit" />
				<jsp:param name="button_action" value="edit" />
				<jsp:param name="button_tooltip" value="${f:message(LOCALE, 'Modifica')}" />
			</jsp:include>
		</div>
	</div>
	
	<c:if test="${not empty POJO.descrizione}">
		<div class="body">${f:formatForHTML(POJO.descrizione)}</div>
	</c:if>

	<c:if test="${not empty POJO.note}">
		<div class="note">${f:formatForHTML(POJO.note)}</div>
	</c:if>
</div>