<%@ include file="/_core/system/directives.jsp" %>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<%
	String domain = request.getServerName();

	String[] logos  = {"_load/img/logo.png",  "app/_custom/img/logo.png",  "app/_custom/img/logo.".concat(domain).concat(".png")};
	String[] icons = {"_load/img/icon.png", "app/_custom/img/icon.png", "app/_custom/img/icon.".concat(domain).concat(".png")};

	String logo = null;
	String icon = null;
	for(String file : logos) if (Util.fileExists(file)) logo = file;
	for(String file : icons) if (Util.fileExists(file)) icon = file;
	
	String coreRes = Util.fileExists("_load/resources.list") ? "1" : "0";
	String appRes = Util.fileExists("app/_custom/resources.list") ? "1" : "0";
	
	application.setAttribute("NAME", Application.getName());
	application.setAttribute("LOGO", Application.getContextPath().concat("/").concat(logo));
	application.setAttribute("ICON", Application.getContextPath().concat("/").concat(icon));
	pageContext.setAttribute("CORE_RES", coreRes);
	pageContext.setAttribute("APP_RES", appRes);
	
	if (Util.fileExists("app/_custom/css/style.css"))
		pageContext.setAttribute("CUSTOM_CSS", "1");
%>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<!DOCTYPE html>
<html lang="it-IT" dir="ltr">

<head>
	<title><%= Util.trim(Util.coalesce(Util.getTextFileContent(Util.getRealPath("app/_custom/title.".concat(domain).concat(".txt"))), Application.getName(), Application.getCustomerName())) %></title>
	<meta role="start" name="domain" content="${domain}" />
	<meta role="start" name="contextPath" content="${APPLICATION.contextPath}" />
	<meta role="start" name="coreRes" content="${CORE_RES}" />
	<meta role="start" name="appRes" content="${APP_RES}" />
	
	<meta charset="UTF-8" />
	<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
	
	<link rel="icon" href="${ICON}" type="image/png" />
	<link rel="shortcut icon" href="${ICON}" type="image/png" />
	
	<link rel="preconnect" href="https://fonts.googleapis.com" crossorigin>
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>

	<%-- link CDN
	<link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap" />
	<link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Roboto+Condensed:ital,wght@0,300;0,400;0,700;1,300;1,400;1,700&display=swap" />
	<link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Roboto+Mono:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;1,100;1,200;1,300;1,400;1,500;1,600;1,700&display=swap" />
	<link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Material+Icons" />
	
	<link href="https://unpkg.com/material-components-web@latest/dist/material-components-web.min.css" rel="stylesheet" />
	<script src="https://unpkg.com/material-components-web@latest/dist/material-components-web.min.js"></script>
	 --%>
	 
	<%-- link locali --%>
	<link rel="stylesheet" href="${APPLICATION.contextPath}/_load/css/Roboto.css" />
	<link rel="stylesheet" href="${APPLICATION.contextPath}/_load/css/RobotoCondensed.css" />
	<link rel="stylesheet" href="${APPLICATION.contextPath}/_load/css/RobotoMono.css" />
	<link rel="stylesheet" href="${APPLICATION.contextPath}/_load/css/MaterialIcons.css" />
	
	<link rel="stylesheet" href="${APPLICATION.contextPath}/_load/css/mdc.css" />
	<script defer src="${APPLICATION.contextPath}/_load/js/mdc.js"></script>



	<%--
		MDC JS
		ricordarsi di commentare il log di "(mdc-auto-init) Component already initialized for"
	--%>
	<%--
		MDC CSS
		rgba(98,0,238,.*) -> var(--mdc-theme-primary-*) -- cercare rgba(98,0,238,. e sostituire con var(--mdc-theme-primary-
		:#6200ee  -> :var(--mdc-theme-primary, #6200ee)
	--%>
	
	<%-- FontAwesome --%>
	<link rel="stylesheet" href="${APPLICATION.contextPath}/_load/css/FontAwesome.css" />
	
	<%-- impostazione delle variabili usate nei CSS --%>
	<link rel="stylesheet" href="${APPLICATION.contextPath}/_load/css/reset.css" />
	<%-- pesonalizzazione dei colori di MDC in base all'applicazione (costante, non verrà rimosso dopo il caricamento del layout) --%>
	<c:if test="${not empty CUSTOM_CSS}">
		<link rel="stylesheet" href="${APPLICATION.contextPath}/app/_custom/css/style.css" />
	</c:if>

	<%-- risorse per l'avviamento dell'appllicazione (role="start" -> verranno rimosse dopo il caricamento) --%>	
	<link role="start" rel="stylesheet" href="${APPLICATION.contextPath}/_load/css/start.css" />
	<script role="start" defer src="${APPLICATION.contextPath}/_load/js/start.js"></script>
</head>

<body class="mdc-typography">
	<img class="app-logo" src="${LOGO}" />
	
	<div role="progressbar" class="mdc-linear-progress mdc-linear-progress--indeterminate">
		<div class="mdc-linear-progress__buffer">
			<div class="mdc-linear-progress__buffer-bar"></div>
			<div class="mdc-linear-progress__buffer-dots"></div>
		</div>
		<div class="mdc-linear-progress__bar mdc-linear-progress__primary-bar">
			<span class="mdc-linear-progress__bar-inner"></span>
		</div>
		<div class="mdc-linear-progress__bar mdc-linear-progress__secondary-bar">
			<span class="mdc-linear-progress__bar-inner"></span>
		</div>
	</div>
	
	<div class="app-load-error app-load-error-hidden"></div>
</body>

</html>